function i=strmatchi(str,strs,flag)
% i=strmatchi(str,strs,flag)  --- find location of str in strs
% where str is a string and strs a cell array with strings.
%
% Almost the same as function strmatch, however, if flag is given
% than a no-hit will yield i=0 instead of an empty matrix and no error message.
% Without flag a no hit yields an error message and shows str and strs
% for easy reference by the user.
% if flag=='exact' than an exact match is required not just the first
% characters of strs{i} must match str.
% Contrary to strmatch, strmatchi is not case sensitive.


% TO 070630 081231 100120


% Copyright 2010 Theo Olsthoorn, TU-Delft and Waternet, without any warranty
% under free software foundation GNU license version 3 or later


if nargin>2 && strcmpi(flag,'exact')  % case insensitive comparison
    i=strmatch(upper(str),upper(strs),'exact');  % case insensitve
else
    i=strmatch(upper(str),upper(strs));          % case insensitive
end

if isempty(i)
    if nargin>2  % in case agrument 3 is given, whatever value
        i=0;
    else % error message also showing str and strs
        for i=1:length(strs), fprintf(' %s',strs{i}); end
        fprintf('\n');
        error(['Can''t find header ''',str,''' in list above!']);
    end
end

% if no error, just return i
